
IF  NOT EXISTS (SELECT * FROM sys.objects 
WHERE object_id = OBJECT_ID(N'[dbo].[INTEGRADOR_VTEX_CONTROLE_PEDIDO]') AND type in (N'U'))
BEGIN

   CREATE TABLE [dbo].[INTEGRADOR_VTEX_CONTROLE_PEDIDO](
	   [CODIGO_TELEVENDAS] [int] NOT NULL,
	   [CODIGO_ECOMMERCE_FORMATADO] [bigint] NOT NULL,
	   [CODIGO_ECOMMERCE] [varchar](max) NOT NULL,
	   [PRECO_TOTAL] [money] NOT NULL,
	   [CODIGO_FILIAL] [int] NOT NULL,
	   [JSON_RECEBIDO] [text] NOT NULL,
	   [STATUS_PEDIDO] [varchar](40) NOT NULL,
	   [DATA_CADASTRO] [datetime] NULL,
	   [JSON_ENVIADO] [text] NOT NULL,
	   [NOME_CLIENTE] [varchar](255) NULL,
	   [CPF] [varchar](50) NULL,
    CONSTRAINT [PK_INTEGRADOR_VTEX_CONTROLE_PEDIDO_] PRIMARY KEY CLUSTERED 
   (
	   [CODIGO_TELEVENDAS] ASC,
	   [CODIGO_ECOMMERCE_FORMATADO] ASC
   )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
   ) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

   SET ANSI_PADDING ON

   /****** Object:  Index [ix_INTEGRADOR_VTEX_CONTROLE_PEDIDO]    Script Date: 18/11/2021 11:44:57 ******/
   CREATE NONCLUSTERED INDEX [ix_INTEGRADOR_VTEX_CONTROLE_PEDIDO] ON [dbo].[INTEGRADOR_VTEX_CONTROLE_PEDIDO]
   (
	   [STATUS_PEDIDO] ASC,
	   [DATA_CADASTRO] ASC
   )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

   ALTER TABLE [dbo].[INTEGRADOR_VTEX_CONTROLE_PEDIDO] ADD  DEFAULT (getdate()) FOR [DATA_CADASTRO]

END;
